﻿
$(function () {
    // Visualiza el footer
    $('#mainFooter').removeClass('footerHidden');

    // Inbox all
    dtSettings = {
        order: [],
        stateSabe: true,
        pagingType: 'simple_numbers',
        responsive: {
            details: { type: 'column' }
        },
        dom: 'flirtip',
        columns: [
            { name: null, data: null, sortable: false, searchable: false },
            { name: 'Function', "data": null, title: "", sortable: false, searchable: false },
            { name: 'Descripcion', "data": 'description', title: titleDescription, sortable: false, searchable: true },
            { name: 'From', "data": null, title: titleFrom, sortable: false, searchable: false },
            { name: 'Started', "data": 'started', title: titleStarted, sortable: true, searchable: true },
            { name: 'Due', "data": null, title: titleDue, sortable: false, searchable: false },
            { name: 'InsId', "data": 'insId', title: '#', sortable: true, searchable: true },
            { name: 'Locked', "data": 'locked', visible: false, sortable: false, searchable: false },
            { name: 'MenuDesc', "data": 'menuDesc', title: titleMenuDesc, sortable: false, searchable: false },
        ],
        columnDefs: [
            {
                targets: [0],
                defaultContent: '<p>&nbsp;</p>',
                className: 'control'
            },
            {
                targets: [1],
                render: function (data, type, full, meta) {
                    var ctrl = '';
                    var i = 0;
                    if (data.fncDefs !== undefined) {
                        var fnc = {};
                        var lottypes = "customlots asplots asptracer ";
                        var count = Object.keys(data.fncDefs).length;
                        ctrl = '<div class="btn-group">';
                        // primer botón
                        if (count === 0 || data.locked) {
                            var tooltip_lock_unlock = (data.locked ? titleUnLock : titleLock);
                            ctrl += "<button class='btn btn-default' type='button' data-toggle='tooltip' title='" + tooltip_lock_unlock + "'" +
                                " onclick='InstanceLockUnLock(" + (data.locked ? "false" : "true") +
                                ", \"" + data.orgid + "\",\"" + data.uoid + "\",\"" + data.proid + "\"," + data.pngid + "," + data.versionid + "," + data.subproid + "," + data.actid + "," +
                                data.insId + ", $(\"#inbox\") );'><i class='fa " + (data.locked ? "fa-unlock-alt" : "fa-lock") + " fa-lg'></i></button>";
                        }
                        else {
                            var hayDefault = false;
                            for (i = 0; i < count; i++) {
                                fnc = data.fncDefs[i];
                                if (fnc.Default && lottypes.indexOf(fnc.TypeId.toLowerCase() + ' ') === -1) {
                                    hayDefault = true;
                                    break;
                                }
                            }
                            if (!hayDefault) 
                            {
                                // Fuerza el primero no lots como Default
                                for (i = 0; i < count; i++) {
                                    if (lottypes.indexOf(data.fncDefs[i].TypeId.toLowerCase() + ' ') === -1) {
                                        data.fncDefs[i].Default = true;
                                        hayDefault = true;
                                        break;
                                    }
                                }
                            }
                            if (hayDefault) {
                                for (i = 0; i < count; i++) {
                                    fnc = data.fncDefs[i];
                                    if (fnc.Default && lottypes.indexOf(fnc.TypeId.toLowerCase() + ' ') === -1) {
                                        ctrl += "<button class='btn btn-default' type='button' data-toggle='tooltip' title='" + fnc.Description + "'" +
                                            " onclick='this.disabled=true;LaunchFunction(" + JSON.stringify(fnc.Definition) + "," +
                                            "\"" + data.orgid + "\",\"" + data.uoid + "\",\"" + data.proid + "\"," + data.pngid + "," + data.versionid + "," + data.subproid + "," + data.actid + "," +
                                            fnc.Id + "," + data.insId + "," + "true," + "\"" + data.guid + "\"," + "\"" + fnc.Definition.ConnectorType + "\"," + "\"" + fnc.Definition.PathParameters64 + "\"" + ");'><i class='fa fa-play-circle fa-lg'></i></button>";
                                        break;
                                    }
                                }
                            } else 
                                ctrl += "<button class='btn btn-default' type='button'><i class='fa fa-ban fa-lg'></i></button>";
                        }

                        ctrl += "<button class='btn btn-default dropdown-toggle' type='button' data-toggle='dropdown'><span class='caret'></span></button>";
                        ctrl += "<ul class='dropdown-menu' role='menu'>";
                        if (count !== 0 && !data.locked) {
                            // conectores adicionales
                            var bAdded = false;
                            for (i = 0; i < count; i++) {
                                fnc = data.fncDefs[i];
                                if (!fnc.Default && lottypes.indexOf(fnc.TypeId.toLowerCase() + ' ') === -1) {
                                    ctrl += "<li><a href='javascript:void(0)' onclick='this.disabled=true;LaunchFunction(" + JSON.stringify(fnc.Definition) + "," +
                                        "\"" + data.orgid + "\",\"" + data.uoid + "\",\"" + data.proid + "\"," + data.pngid + "," + data.versionid + "," + data.subproid + "," + data.actid + "," +
                                        fnc.Id + "," + data.insId + "," + "true," + "\"" + data.guid + "\"," + "\"" + fnc.Definition.ConnectorType + "\"," + "\"" + fnc.Definition.PathParameters64 + "\"" + ");'><i class='fa fa-play-circle-o'></i> " + fnc.Description + "</a></li>";
                                    bAdded = true;
                                }
                            }
                            ctrl += (bAdded ? '<li class="divider"></li>' : '');
                            // bloquear / desbloquear
                            ctrl += "<li><a href='javascript:void(0)' onclick='InstanceLockUnLock(" + (data.locked ? "false" : "true") +
                                ", \"" + data.orgid + "\",\"" + data.uoid + "\",\"" + data.proid + "\"," + data.pngid + "," + data.versionid + "," + data.subproid + "," + data.actid + "," +
                                data.insId + ", $(\"#inbox\") );'><i class='fa " + (data.locked ? "fa-unlock-alt" : "fa-lock") + "'></i>" +
                                 (data.locked ? titleUnlock : titleLock) + "</a></li>";
                        }
                        // trace de texto
                        ctrl += "<li><a href='javascript:void(0)' onclick='TextTrace(this," + data.pngid + "," + data.versionid + "," + data.subproid + "," + data.actid + ");'" +
                            "><i class='fa fa-crosshairs'></i>" + titleTextTrace + "</a></li>";
                        ctrl += '</ul>';
                        ctrl += '</div>';
                    }
                    return ctrl;
                }
            },
            {
                targets: [2], width: '40%',
                render: function (data, type, full, meta) {
                    return '<p style="word-break: normal; white-space:normal">' + data + '</p>';
                }
            },
            {
                targets: [3],
                render: function (data, type, full, meta) {
                    return '<a href="mailto:' + data.email + '">' + data.lastName + ', ' + data.firstName + '</a>';
                }
            },
            {
                targets: [4],
                render: function (data) {
                    var sDate = '-';
                    if (moment(data).isValid()) {
                        sDate = moment(data).format("L") + ' ' + moment(data).format("HH:mm:ss");
                    }
                    return sDate;
                }
            },
            {
                targets: [5],
                render: function (data, type, full, meta) {
                    var sRet = '';
                    if (moment(data.dueLog).isValid()) {
                        if (data.due)
                            sRet = '<p class="text-red">' + moment(data.dueLog).format("L") + ' ' + moment(data.dueLog).format("HH:mm:ss") + '</p>';
                        else
                            sRet = '<p>' + moment(data.dueLog).format("L") + ' ' + moment(data.dueLog).format("HH:mm:ss") + '</p>';
                    }
                    return sRet;
                }
            }
        ],
        createdRow: function (row, data, dataIndex) {
            if (data.locked) {
                $(row).css('background-color', '#E5E7E9');
            }
        }
    };

  


    if (oLanguage)
        dtSettings.language = oLanguage;
    else
        dtSettings.language = { emptyTable: "No instances for today" };


    var barChartOptions = {
        //Boolean - Whether grid lines are shown across the chart
        scaleShowGridLines: true,
        //String - Colour of the grid lines
        scaleGridLineColor: "rgba(0,0,0,.05)",
        //Number - Width of the grid lines
        scaleGridLineWidth: 1,
        //Boolean - Whether to show horizontal lines (except X axis)
        scaleShowHorizontalLines: true,
        //Boolean - Whether to show vertical lines (except Y axis)
        scaleShowVerticalLines: true,
        //Boolean - If there is a stroke on each bar
        barShowStroke: true,
        //Number - Pixel width of the bar stroke
        barStrokeWidth: 2,
        //Number - Spacing between each of the X value sets
        barValueSpacing: 5,
        //Number - Spacing between data sets within X values
        barDatasetSpacing: 1,
        //String - A legend template
        legendTemplate: "<ul class=\"<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<datasets.length; i++){%><li><span style=\"background-color:<%=datasets[i].fillColor%>\"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>",
        //Boolean - whether to make the chart responsive
        responsive: true,
        maintainAspectRatio: false,
        //Cursor con dedo señalador sobre las barras
        hover: {
            onHover: function (e, el) {
                $("#inboxChart").css("cursor", el[0] ? "pointer" : "default");
            }
        },
        scales: {
            yAxes: [{
                display: true,
                ticks: {
                    beginAtZero: true,
                    callback: function (value) { if (value % 1 === 0) { return value; } }
                }
            }]
        }
    };

    var myChart;
    var lstActs;

    $('#inboxChartLoading').show();
    $('#inboxAllLoading').show();
    $.ajax({
        cache: false,
        url: UrlDashboardData,
        type: 'GET',
        datatype: 'json',
        success: function (resp) {
            if (resp.status === 200) {
                var canvas = document.getElementById("inboxChart");
                var ctx = canvas.getContext('2d');
                myChart = new Chart(ctx, {
                    type: 'bar',
                    data: resp.data.chart.Data,
                    options: barChartOptions
                });

                dtSettings.data = resp.data.today;
                $("#inbox").DataTable(dtSettings);

                lstActs = resp.data.chart.Data.lstActs;
                canvas.onclick = function (evt) {
                    var activePoints = myChart.getElementAtEvent(evt);
                    var firstPoint = activePoints[0];
                    if (firstPoint !== undefined) {
                        if (firstPoint._index < lstActs.length && firstPoint._datasetIndex < lstActs[firstPoint._index].yValues.length) {

                            var actividad = lstActs[firstPoint._index];
                            var orgUoPrf = lstActs[firstPoint._index].yValues[firstPoint._datasetIndex];
                            var params = new Object();

                            params.pngId = actividad.PngId;
                            params.versionId = actividad.VersionId;
                            params.subProId = actividad.SubProId;
                            params.actId = actividad.ActId;
                            params.key = actividad.Key;
                            params.orgId = orgUoPrf.OrgId;
                            params.uoId = orgUoPrf.UoId;
                            params.prfId = orgUoPrf.PrfId;

                            var paramJson = JSON.stringify(params);
                            CallAction(UrlInbox, paramJson);
                        }
                    }
                }

                $("#hPendingActivities").html(resp.data.chart.Data.PendingActivities);
                $("#hTodayInstances").html(resp.data.todaycount);
                $("#hDelayedInstances").html(resp.data.duecount);
                ShowInitialActivities(resp.data.initialactivities, resp.data.guid);
              
            }
            else if (resp.status === 302) {
                $.xhrPool.abortAll();
                window.location.href = resp.data;
            }
            else if (resp.status === 500) {
                alert(resp.data);
            }
        },
        error: function (xhr, ajaxOptions, thrownError) {
            $("#hPendingActivities").html('-');
            $("#hTodayInstances").html('-');
            $("#hDelayedInstances").html('-');
            Common.ShowError(xhr, ajaxOptions, thrownError);
        },
        complete: function (jqXHR, textStatus) {
            $('#inboxChartLoading').hide();
            $('#inboxAllLoading').hide();

            //-----------
            //Cantidad de caracteres hasta que ejecute la busqueda
            setTimeout(function () {


                $('.dataTables_filter input').unbind();
                $('.dataTables_filter input').bind('keyup', function (e) {
                    if (($(this).val().length >= 3 || $(this).val().length == 0) || (e.keyCode == 13)) {
                        $('#inbox').dataTable().fnFilter($(this).val());
                    }
                });
            }, 3000);
            //-----------
        }
    });
});

function ShowInitialActivities(initialactivities, guid) {
    var strHTML = "";
    for (var i = 0; i < initialactivities.Data.TreeViews.length; i++) {
        var tv = initialactivities.Data.TreeViews[i];
        for (var j = 0; j < tv.BusinessProcesses.length; j++) {
            var bp = tv.BusinessProcesses[j];
            var prfid = "";
            if (bp.MenuItems.length > 0) {
                prfid = bp.MenuItems[0].PrfId;

                for (var z = 0; z < bp.MenuItems.length; z++) {
                    var mi = bp.MenuItems[z]
                    strHTML = strHTML + InitialActivities_BuildItem(mi, bp.PngId, bp.VersionId, guid)
                }
            }
        }
    }
    $("#divMiniInbox").html('<ul class="nav nav-pills nav-stacked treemenu">' + strHTML + "</ul>");
}

function InitialActivities_BuildItem(menuItem, piPngId, piVersionId, guid) {
    if (menuItem.Type != 0)
        return "";
    var strHTML = "";
    if (menuItem.BusinessProcessProperties.Functions != null) {
        var fncCant = menuItem.BusinessProcessProperties.Functions.length;
        var lottypes = "customlots asplots asptracer ";
        if (fncCant === 1) {
            var oFunction = menuItem.BusinessProcessProperties.Functions[0];
            if (lottypes.indexOf(oFunction.TypeId.toLowerCase() + ' ') === -1) {
                strHTML = strHTML + "<li dat-type='limenu'><a href='javascript:void(0)' onclick='LaunchFunction(" + DecodeHtml(JSON.stringify(oFunction.Definition)) + ",\"" + menuItem.OrgId + "\",\"" +
                    menuItem.UOId + "\",\"" +
                    menuItem.PrfId + "\"," +
                    piPngId + "," +
                    piVersionId + "," +
                    menuItem.BusinessProcessProperties.SubProId + "," +
                    menuItem.BusinessProcessProperties.ActId + "," +
                    oFunction.Id + ",0,false,\"" +
                    guid + "\",\"" +
                    oFunction.Definition.ConnectorType + "\",\"" +
                    DecodeHtml(oFunction.Definition.PathParameters64) + "\");'>" +
                    "<i class='fa fa-play-circle'></i>" + menuItem.Description + "</a></li>";
            } else {
                // Custom lots, no lanza conector desde una actividad inicial.
                strHTML += "<li dat-type='limenu'><i class='fa fa-ban fa-lg'></i></li>";
            }
        } else if (fncCant > 1) {
            var devFncsId = menuItem.OrgId + menuItem.UOId + menuItem.PrfId + piPngId + '_' + menuItem.Key.replace('|', '_');
            strHTML += ("<li dat-type='limenu'><a href='#" + devFncsId + "' data-toggle='collapse' aria-expanded='false'>");
            strHTML += "<i class='fa fa-chevron-right'></i>";
            strHTML += ("<i class='fa fa-chevron-down'></i>" + menuItem.Description);
            strHTML += "</a></li>";
            strHTML += ("<div id='" + devFncsId + "' class='collapse' style='margin-left:10px;'>");    
            strHTML += "<ul class='nav nav-pills nav-stacked treemenu'>";

            for (var i = 0; i < menuItem.BusinessProcessProperties.Functions.length; i++) {
                var oFnc = menuItem.BusinessProcessProperties.Functions[i];
                if (lottypes.indexOf(oFnc.TypeId.toLowerCase() + ' ') === -1) {
                    strHTML += oFnc.Default ? "<li dat-type='limenu' style='font-weight: bold;'>" : "<li dat-type='limenu'>";
                    strHTML = strHTML + "<a href='javascript:void(0)' onclick='LaunchFunction(" + DecodeHtml(JSON.stringify(oFnc.Definition)) + ",\"" + menuItem.OrgId + "\",\"" +
                        menuItem.UOId + "\",\"" +
                        menuItem.PrfId + "\"," +
                        piPngId + "," +
                        piVersionId + "," +
                        menuItem.BusinessProcessProperties.SubProId + "," +
                        menuItem.BusinessProcessProperties.ActId + "," +
                        oFnc.Id + ",0,false,\"" +
                        guid + "\",\"" +
                        oFnc.Definition.ConnectorType + "\",\"" +
                        DecodeHtml(oFnc.Definition.PathParameters64) + "\");'>" +
                        "<i class='fa fa-play-circle'></i>" + oFnc.Description + "</a>";
                    strHTML += "</li>";
                }
            }
            strHTML += "</ul></div>";
        }
    }
    return strHTML;
}


function DecodeHtml(str) {
    return $('<div/>').html(str).text();
}


function ReloadInboxAll() {
    var table = $('#inbox').DataTable();
    if (table.data().any()) {
        $('#inboxAllLoading').show();
        $.ajax({
            cache: false,
            url: UrlInboxAll,
            type: 'GET',
            datatype: 'json',
            data: { due: 1, date: null },
            success: function (resp) {
                if (resp.status === 302) {
                    $.xhrPool.abortAll();
                    window.location.href = resp.data;
                } else if (resp.status === 200) {
                    table.clear();
                    table.rows.add(resp.data.list);
                    table.draw(false);
                    $("#hTodayInstances").html(resp.data.count);
                }
            },
            complete: function () {
                $('#inboxAllLoading').hide();
            },
            error: function (xhr, ajaxOptions, thrownError) {
                $("#hTodayInstances").html('-');
                Common.ShowError(xhr, ajaxOptions, thrownError);
            }
        });
    }
}


